# Load necessary libraries
library(dplyr)

# Load the CSV data from two files
data1 <- read.csv("external.csv")
data2 <- read.csv("internal.csv")

# Combine the data from the two CSV files
combined_data <- bind_rows(data1, data2)

# Convert relevant columns to factors
combined_data$question <- as.factor(combined_data$question)
combined_data$participant <- as.factor(combined_data$participant)

# Filter out 'convincing' and 'guiding' responses
convincing_responses <- combined_data %>%
  filter(question == "convincing") %>%
  pull(response)

guiding_responses <- combined_data %>%
  filter(question == "guiding") %>%
  pull(response)

# Check if the lengths of responses match for paired comparison
if (length(convincing_responses) == length(guiding_responses)) {
  
  # Perform Wilcoxon signed-rank test (non-parametric)
  wilcoxon_test_result <- wilcox.test(convincing_responses, guiding_responses, paired = TRUE)
  
  # Format and print the p-value with 3 significant digits in scientific notation
  formatted_p_value <- formatC(wilcoxon_test_result$p.value, format = "e", digits = 3)
  cat("Wilcoxon signed-rank test p-value:", formatted_p_value, "\n")
  
} else {
  print("The number of 'convincing' and 'guiding' responses are not equal, adjust data accordingly.")
}
